/*
 * Decompiled with CFR 0.152.
 */
package JosAertsBeans;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JApplet;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JNumberField
extends JTextField
implements KeyListener,
CaretListener,
FocusListener {
    private String typingArea;
    private JApplet parent;
    private boolean dotAllReady = false;
    private int dotPosition = 0;
    private boolean eAllReady = false;
    private int ePosition = 0;
    private boolean firstSignAllReady = false;
    private int firstSignPosition = 0;
    private boolean secondSignAllReady = false;
    private int secondSignPosition = 0;
    private boolean valueAllRight = false;
    private boolean NotANumber = false;
    private boolean usedRemoveKey = false;
    private boolean fieldEmpty = true;

    public JNumberField(int Columns) {
        this.setColumns(Columns);
        this.addKeyListener(this);
        this.addCaretListener(this);
        this.addFocusListener(this);
    }

    public JNumberField() {
        this.addKeyListener(this);
        this.addCaretListener(this);
        this.addFocusListener(this);
    }

    public void keyTyped(KeyEvent evtKey) {
        this.testKeyTyped(evtKey);
    }

    public void keyPressed(KeyEvent evtKey) {
        this.testKeyPressed(evtKey);
    }

    public void keyReleased(KeyEvent evtKey) {
    }

    public void caretUpdate(CaretEvent evtCaret) {
        this.testCaretUpdate(evtCaret);
    }

    public void focusGained(FocusEvent evtFocus) {
        this.selectAll();
    }

    public void focusLost(FocusEvent evtFocus) {
    }

    private void testKeyTyped(KeyEvent evtKey) {
        char kChar = evtKey.getKeyChar();
        int kCode = evtKey.getKeyCode();
        if ('0' <= kChar && kChar <= '9' || kChar == '.' || kChar == 'e' || kChar == 'E' || kChar == '-' || kChar == '+') {
            if ('0' > kChar || kChar > '9') {
                switch (kChar) {
                    case '.': {
                        this.dotTest(evtKey);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        this.eTest(evtKey);
                        break;
                    }
                    case '+': 
                    case '-': {
                        this.signTest(evtKey);
                        break;
                    }
                    default: {
                        this.errorInput(evtKey);
                        break;
                    }
                }
            } else {
                this.valueAllRight = true;
            }
        } else if (this.usedRemoveKey) {
            this.usedRemoveKey = false;
        } else {
            this.errorInput(evtKey);
        }
        if (this.valueAllRight) {
            this.testSymbolPosition();
        }
    }

    private void testKeyPressed(KeyEvent evtKey) {
        char kChar = evtKey.getKeyChar();
        int kCode = evtKey.getKeyCode();
        if (('0' > kChar || kChar > '9') && kChar != '.' && kChar != 'e' && kChar != 'E' && kChar != '-' && kChar != '+') {
            if (kCode == 8 || kCode == 127 || kCode == 16 || kCode == 35 || kCode == 37 || kCode == 39 || kCode == 36) {
                switch (kCode) {
                    case 8: {
                        this.backSpace(evtKey);
                        break;
                    }
                    case 127: {
                        this.delKey(evtKey);
                        break;
                    }
                    case 36: {
                        this.setCaretPosition(0);
                    }
                }
            } else {
                this.errorInput(evtKey);
            }
        } else if (('0' > kChar || kChar > '9') && kChar != '.' && kChar != 'e' && kChar != 'E' && kChar != '-' && kChar != '+') {
            this.errorInput(evtKey);
        }
    }

    private void testCaretUpdate(CaretEvent evtCaret) {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        if (this.getSelectionStart() != this.getSelectionEnd() && this.getSelectionStart() != 0 && this.getSelectionStart() < this.getSelectionEnd()) {
            this.selectAll();
        }
        if (tempStringBuf.length() == 0) {
            this.resetParameters();
        }
    }

    private void dotTest(KeyEvent evtKey) {
        if (!(this.dotAllReady || this.ePosition <= this.getCaretPosition() + 1 && this.eAllReady)) {
            this.dotAllReady = true;
            this.dotPosition = this.getCaretPosition();
            this.valueAllRight = true;
        } else {
            this.errorInput(evtKey);
        }
    }

    private void eTest(KeyEvent evtKey) {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        if (!this.eAllReady && this.getCaretPosition() > 0 && '0' <= tempStringBuf.charAt(this.getCaretPosition() - 1) && tempStringBuf.charAt(this.getCaretPosition() - 1) <= '9' && this.dotPosition < this.getCaretPosition()) {
            this.eAllReady = true;
            this.ePosition = this.getCaretPosition();
            this.valueAllRight = true;
        } else {
            this.errorInput(evtKey);
        }
    }

    private void signTest(KeyEvent evtKey) {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        if (!this.firstSignAllReady && this.getCaretPosition() == 0) {
            this.firstSignAllReady = true;
            this.firstSignPosition = this.getCaretPosition();
            this.valueAllRight = true;
        } else if (!(this.secondSignAllReady || this.getCaretPosition() <= 1 || tempStringBuf.charAt(this.getCaretPosition() - 1) != 'e' && tempStringBuf.charAt(this.getCaretPosition() - 1) != 'E')) {
            this.secondSignAllReady = true;
            this.secondSignPosition = this.getCaretPosition();
            this.valueAllRight = true;
        } else {
            this.errorInput(evtKey);
        }
    }

    private void backSpace(KeyEvent evtKey) {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        this.usedRemoveKey = true;
        if (this.getCaretPosition() == 0) {
            this.errorInput(evtKey);
        } else if (this.getSelectionStart() != this.getSelectionEnd()) {
            this.resetParameters();
        } else if (this.getCaretPosition() > 0) {
            if ('0' > tempStringBuf.charAt(this.getCaretPosition() - 1) || tempStringBuf.charAt(this.getCaretPosition() - 1) > '9') {
                switch (tempStringBuf.charAt(this.getCaretPosition() - 1)) {
                    case '.': {
                        this.dotRemove(evtKey);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        this.eRemove(evtKey);
                        break;
                    }
                    case '+': 
                    case '-': {
                        this.signRemove(evtKey);
                    }
                }
            } else if (tempStringBuf.length() > this.getCaretPosition() && (this.firstSignPosition == this.getCaretPosition() - 2 || this.dotPosition == this.getCaretPosition() - 2) && this.ePosition == this.getCaretPosition()) {
                this.errorInput(evtKey);
            } else if (tempStringBuf.length() > 0 && this.getCaretPosition() < tempStringBuf.length()) {
                if (this.getCaretPosition() < this.dotPosition || tempStringBuf.charAt(this.getCaretPosition()) == '.') {
                    --this.dotPosition;
                }
                if (this.getCaretPosition() < this.ePosition || tempStringBuf.charAt(this.getCaretPosition()) == 'e' || tempStringBuf.charAt(this.getCaretPosition()) == 'E') {
                    --this.ePosition;
                    if (this.secondSignAllReady) {
                        --this.secondSignPosition;
                    }
                }
            }
        }
        if (this.getCaretPosition() == tempStringBuf.length() && this.getCaretPosition() == 0) {
            this.resetParameters();
        }
        if (this.getCaretPosition() != 0 && (tempStringBuf.charAt(0) == '-' || tempStringBuf.charAt(0) == '+') && this.getCaretPosition() == 1) {
            if (this.dotAllReady) {
                --this.dotPosition;
            }
            if (this.eAllReady) {
                --this.ePosition;
                if (this.secondSignAllReady) {
                    --this.secondSignPosition;
                }
            }
        }
    }

    private void delKey(KeyEvent evtKey) {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        this.usedRemoveKey = true;
        if (this.getCaretPosition() == tempStringBuf.length()) {
            this.errorInput(evtKey);
        } else {
            if (this.getSelectionStart() != this.getSelectionEnd()) {
                this.resetParameters();
            } else if (this.getCaretPosition() >= 0 && ('0' > tempStringBuf.charAt(this.getCaretPosition()) || tempStringBuf.charAt(this.getCaretPosition()) > '9')) {
                switch (tempStringBuf.charAt(this.getCaretPosition())) {
                    case '.': {
                        this.dotRemove(evtKey);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        this.eRemove(evtKey);
                        break;
                    }
                    case '+': 
                    case '-': {
                        this.signRemove(evtKey);
                    }
                }
            }
            if (this.getCaretPosition() == 0 && tempStringBuf.length() == 1) {
                this.resetParameters();
            }
            if (this.getCaretPosition() == 0 && (tempStringBuf.charAt(this.getCaretPosition()) == '+' || tempStringBuf.charAt(this.getCaretPosition()) == '-')) {
                this.firstSignAllReady = false;
            }
            if (this.getCaretPosition() < this.dotPosition) {
                if (this.dotAllReady) {
                    --this.dotPosition;
                } else {
                    this.errorInput(evtKey);
                }
            }
            if (this.getCaretPosition() < this.ePosition) {
                if (this.eAllReady) {
                    --this.ePosition;
                    if (this.secondSignAllReady) {
                        --this.secondSignPosition;
                    }
                } else {
                    this.errorInput(evtKey);
                }
            }
        }
    }

    private void dotRemove(KeyEvent evtKey) {
        this.dotAllReady = false;
        this.dotPosition = 0;
    }

    private void eRemove(KeyEvent evtKey) {
        if (!this.secondSignAllReady) {
            this.eAllReady = false;
            this.ePosition = 0;
        } else {
            this.errorInput(evtKey);
        }
    }

    private void signRemove(KeyEvent evtKey) {
        if (this.getCaretPosition() <= 1) {
            this.firstSignAllReady = false;
            this.firstSignPosition = 0;
        } else {
            this.secondSignAllReady = false;
            this.secondSignPosition = 0;
        }
    }

    private void testSymbolPosition() {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        if (tempStringBuf.length() > 0 && this.getCaretPosition() < tempStringBuf.length()) {
            if (this.getCaretPosition() < this.dotPosition || tempStringBuf.charAt(this.getCaretPosition()) == '.') {
                ++this.dotPosition;
            }
            if (this.getCaretPosition() < this.ePosition || tempStringBuf.charAt(this.getCaretPosition()) == 'e' || tempStringBuf.charAt(this.getCaretPosition()) == 'E') {
                ++this.ePosition;
                if (this.secondSignAllReady) {
                    ++this.secondSignPosition;
                }
            }
        }
        this.valueAllRight = false;
    }

    public double getDoubleValue() {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        return this.atof(tempStringBuf.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double atof(String s) {
        int i;
        int sign = 1;
        double r = 0.0;
        double f = 0.0;
        double p = 1.0;
        boolean state = false;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length() && ('0' <= s.charAt(i) && s.charAt(i) <= '9' || s.charAt(i) == 'e' || s.charAt(i) == 'E' || s.charAt(i) == '.')) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (!state) {
                    r = r * (double)10 + (double)ch - (double)48;
                } else if (state) {
                    r += (p /= (double)10) * (double)(ch - 48);
                }
            } else if (ch == '.') {
                if (state) return (double)sign * r;
                state = true;
            } else {
                if (ch != 'e' && ch != 'E') return (double)sign * r;
                long e = (int)this.parseLong(s.substring(i + 1), 10);
                return (double)sign * r * Math.pow(10.0, e);
            }
            ++i;
        }
        if (i >= s.length()) return (double)sign * r;
        this.NotANumber = true;
        return 0.0;
    }

    private long parseLong(String s, int base) {
        int i;
        int sign = 1;
        long r = 0L;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' > ch || ch >= 48 + base) {
                this.NotANumber = true;
                return 0L;
            }
            r = r * (long)base + (long)ch - (long)48;
            ++i;
        }
        return r * (long)sign;
    }

    public boolean isFieldEmpty() {
        StringBuffer tempStringBuf = new StringBuffer(this.getText());
        if (tempStringBuf.length() != 0) {
            Double D = new Double(this.getDoubleValue());
            if (this.NotANumber || D.isInfinite()) {
                this.noValidField();
            } else {
                this.fieldEmpty = false;
            }
        } else {
            this.fieldEmpty = true;
        }
        this.NotANumber = false;
        return this.fieldEmpty;
    }

    public void errorInput(KeyEvent evtKey) {
        evtKey.consume();
        evtKey.consume();
        this.validate();
        this.usedRemoveKey = false;
        Toolkit.getDefaultToolkit().beep();
    }

    public void noValidField() {
        Toolkit.getDefaultToolkit().beep();
        this.resetParameters();
        this.setText("");
        Toolkit.getDefaultToolkit().beep();
    }

    public void resetParameters() {
        this.dotAllReady = false;
        this.dotPosition = 0;
        this.eAllReady = false;
        this.ePosition = 0;
        this.firstSignAllReady = false;
        this.secondSignPosition = 0;
        this.secondSignAllReady = false;
        this.secondSignPosition = 0;
        this.valueAllRight = false;
        this.NotANumber = false;
        this.usedRemoveKey = false;
        this.fieldEmpty = true;
    }
}

