/*
 * Decompiled with CFR 0.152.
 */
package Radioactivity;

import Radioactivity.SplitString;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;

public class ReadNuclides {
    URL docbase = null;
    String filename = null;
    String[] nuclides = new String[100];
    String[] nuclidenumbersstring = new String[100];
    int[] nuclidenumbers = new int[100];
    double[] halflife = new double[100];
    int numnuclides = 0;

    public ReadNuclides(URL DocBase, String FileName) {
        this.docbase = DocBase;
        this.filename = FileName;
        try {
            String inputLine;
            URL url = new URL(this.docbase, this.filename);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            int i = 0;
            while ((inputLine = in.readLine()) != null) {
                SplitString ss = new SplitString();
                ss.setDelimiter(' ');
                ss.setString(inputLine);
                String[] sarray = ss.getStringArray();
                this.nuclides[i] = sarray[0];
                this.nuclidenumbersstring[i] = sarray[1];
                try {
                    this.nuclidenumbers[i] = Integer.parseInt(sarray[1]);
                    this.halflife[i] = Double.parseDouble(sarray[2]);
                }
                catch (NumberFormatException e) {
                    System.out.println(String.valueOf("Illegal format in input : ").concat(String.valueOf(inputLine)));
                }
                ++i;
            }
            this.numnuclides = i;
            System.out.println(String.valueOf(this.numnuclides).concat(String.valueOf(" number of nuclides found in input file")));
        }
        catch (FileNotFoundException e) {
            System.out.println("\nERROR ***** File with nuclide data not found ! *****\n");
        }
        catch (Exception e) {
            System.out.println("\nERROR ***** Error during reading input file ! *****\n");
        }
    }

    public String[] getNuclides() {
        return this.nuclides;
    }

    public String[] getNuclidenumbersstring() {
        return this.nuclidenumbersstring;
    }

    public int[] getNuclidenumbers() {
        return this.nuclidenumbers;
    }

    public double[] getHalflife() {
        return this.halflife;
    }

    public int getNumberofnuclides() {
        return this.numnuclides;
    }
}

