/*
 * Decompiled with CFR 0.152.
 */
package Radioactivity;

import Radioactivity.DateActivityPanel;
import Radioactivity.ErrorPane;
import Radioactivity.GUIProperties;
import Radioactivity.JResultsFrame;
import Radioactivity.RadioButtonPanel;
import Radioactivity.ReadNuclides;
import Radioactivity.SplitString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DecayApplet
extends JApplet {
    boolean isStandalone = false;
    String DecayFile;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    JLabel jLabelNuclide = new JLabel();
    JCheckBox jCheckBoxAlphabetic = new JCheckBox();
    String emptyString = new String("      ");
    JList jListNuclides = new JList();
    JButton jButtonPerTable = new JButton();
    JLabel jLabelHalfLife = new JLabel();
    JButton jButtonCalculate = new JButton("Calculate");
    JLabel jLabelJosAerts = new JLabel("Developed by J.Aerts, Computer Chemistry Consultancy");
    DateActivityPanel dap1;
    DateActivityPanel dap2;
    RadioButtonPanel rbp;
    String nuclidename = "";
    String appletlabel = "Radioactive Decay Calculator";
    JLabel jAppletLabel = new JLabel(this.appletlabel);
    String[] nuclides;
    String[] nuclidenumbersstring;
    int[] nuclidenumbers;
    double[] halflife;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.DecayFile = this.getParameter("decayfile", "Nuclides.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this._$1610();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _$1610() throws Exception {
        this.setSize(new Dimension(700, 300));
        this.getContentPane().setLayout(this.gbl);
        GUIProperties guiprop = new GUIProperties();
        guiprop.setTextFieldPrefDimension(new Dimension(80, 25));
        this.jLabelNuclide.setFont(new Font("Dialog", 1, 12));
        this.jLabelNuclide.setForeground(Color.black);
        this.jLabelNuclide.setText("Nuclide: ");
        this.jCheckBoxAlphabetic.setToolTipText("Sort nuclides alphabetically");
        this.jCheckBoxAlphabetic.setText("Alphabetic");
        this.jCheckBoxAlphabetic.setFont(new Font("Dialog", 1, 12));
        this.jCheckBoxAlphabetic.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DecayApplet.this.jCheckBoxAlphabetic_stateChanged(e);
            }
        });
        this.jListNuclides.setToolTipText("List of Nuclides");
        this.jListNuclides.setVisibleRowCount(5);
        this.jListNuclides.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DecayApplet.this.jListNuclides_valueChanged(e);
            }
        });
        JScrollPane sp = new JScrollPane(this.jListNuclides);
        this.jButtonPerTable.setBackground(Color.green);
        this.jButtonPerTable.setFont(new Font("Dialog", 1, 12));
        this.jButtonPerTable.setToolTipText("Show Periodic Table - not implemented (yet)");
        this.jButtonPerTable.setText("Periodic Table");
        this.jButtonPerTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecayApplet.this.jButtonPerTable_actionPerformed(e);
            }
        });
        this.jLabelHalfLife.setFont(new Font("Dialog", 1, 12));
        this.jLabelHalfLife.setForeground(Color.black);
        this.jLabelHalfLife.setText("Half Life (days) :    ");
        this.dap1 = new DateActivityPanel(guiprop);
        this.dap2 = new DateActivityPanel(guiprop, true);
        this.dap1.setGUIPropClass(guiprop);
        this.dap2.setGUIPropClass(guiprop);
        this.rbp = new RadioButtonPanel();
        this.rbp.setComponentA(this.dap2.getTextField1());
        this.rbp.setComponentB(this.dap2.getButton());
        this.rbp.setComponentC(this.dap2.getTextField2());
        this.jButtonCalculate.setFont(new Font("Dialog", 1, 12));
        this.jButtonCalculate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecayApplet.this.jButtonCalculate_actionPerformed(e);
            }
        });
        this.jButtonCalculate.setBackground(Color.cyan);
        this.jAppletLabel.setFont(new Font("Dialog", 3, 20));
        this.jAppletLabel.setForeground(Color.blue);
        this.jLabelJosAerts.setFont(new Font("Dialog", 1, 12));
        this.jLabelJosAerts.setForeground(Color.black);
        System.out.println(String.valueOf("Will read radioactivity data from : ").concat(String.valueOf(this.DecayFile)));
        ReadNuclides rn = new ReadNuclides(this.getDocumentBase(), this.DecayFile);
        int nn = rn.getNumberofnuclides();
        this.nuclides = rn.getNuclides();
        this.nuclidenumbersstring = rn.getNuclidenumbersstring();
        this.nuclidenumbers = rn.getNuclidenumbers();
        this.halflife = rn.getHalflife();
        String[] tempnuclides = new String[nn];
        for (int i = 0; i < nn; ++i) {
            tempnuclides[i] = String.valueOf(String.valueOf(this.nuclides[i]).concat(String.valueOf("-"))).concat(String.valueOf(this.nuclidenumbersstring[i]));
        }
        this.jListNuclides.setListData(tempnuclides);
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.fill = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.getContentPane().add((Component)this.jLabelNuclide, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridx = 2;
        this.getContentPane().add((Component)this.jLabelHalfLife, this.gbc);
        this.gbc.gridx = 3;
        this.getContentPane().add((Component)this.rbp, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.getContentPane().add((Component)sp, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 1;
        this.getContentPane().add((Component)this.dap1, this.gbc);
        this.gbc.gridx = 3;
        this.getContentPane().add((Component)this.dap2, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)this.jButtonPerTable, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jButtonCalculate, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 4;
        this.getContentPane().add((Component)this.jLabelJosAerts, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.fill = 10;
        this.getContentPane().add((Component)this.jAppletLabel, this.gbc);
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"decayfile", "String", ""}};
        return pinfo;
    }

    void jCheckBoxAlphabetic_stateChanged(ChangeEvent e) {
        System.out.println("checkbox alphabetic sorting state changed");
    }

    void jButtonPerTable_actionPerformed(ActionEvent e) {
        System.out.println("Feature not implemented yet");
        JOptionPane.showMessageDialog(this, "Feature not implemented (yet)", "Periodic Table", 1);
    }

    void jListNuclides_valueChanged(ListSelectionEvent e) {
        this.nuclidename = this.jListNuclides.getSelectedValue().toString();
        this.jLabelNuclide.setText(String.valueOf(String.valueOf("Nuclide : ").concat(String.valueOf(this.jListNuclides.getSelectedValue()))).concat(String.valueOf("  ")));
        this.jLabelHalfLife.setText(String.valueOf("Half Life (days) : ").concat(String.valueOf(this.halflife[this.jListNuclides.getSelectedIndex()])));
    }

    void jButtonCalculate_actionPerformed(ActionEvent e) {
        Component c2;
        Date d1;
        Component c = this.rbp.getComponent(0);
        boolean activitycalculation = false;
        if (c instanceof JRadioButton) {
            activitycalculation = ((JRadioButton)c).isSelected();
        }
        System.out.println(String.valueOf("Activity calculation ").concat(String.valueOf(activitycalculation)));
        if (this.nuclidename == "" || this.nuclidename == null) {
            ErrorPane pane = new ErrorPane("No nuclide selected");
            return;
        }
        double activitynew = 0.0;
        double activityold = 0.0;
        Component c3 = this.dap1.getTextField2();
        String s3 = null;
        if (c3 instanceof JTextField) {
            s3 = ((JTextField)c3).getText();
        }
        try {
            activityold = Double.parseDouble(s3);
            System.out.println(String.valueOf("old activity = ").concat(String.valueOf(activityold)));
        }
        catch (Exception en) {
            activityold = 0.0;
            System.out.println("Invalid activity for activityold");
            ErrorPane ep = new ErrorPane("No valid activity");
            return;
        }
        double thalf = this.halflife[this.jListNuclides.getSelectedIndex()];
        double alpha = (double)-1 * Math.log(0.5) / thalf;
        System.out.println(String.valueOf("alpha = ").concat(String.valueOf(alpha)));
        Date d2 = d1 = null;
        String s1 = null;
        String s2 = null;
        Component c1 = this.dap1.getTextField1();
        if (c1 instanceof JTextField) {
            s1 = ((JTextField)c1).getText();
        }
        System.out.println(String.valueOf("first date = ").concat(String.valueOf(s1)));
        d1 = this.getDateFromString(s1);
        if (d1 == null) {
            return;
        }
        System.out.println(String.valueOf("first date = ").concat(String.valueOf(d1)));
        if (activitycalculation) {
            c2 = this.dap2.getTextField1();
            if (c2 instanceof JTextField) {
                s2 = ((JTextField)c2).getText();
            }
            System.out.println(String.valueOf("second date = ").concat(String.valueOf(s2)));
            d2 = this.getDateFromString(s2);
            if (d2 == null) {
                return;
            }
            System.out.println(String.valueOf("second date = ").concat(String.valueOf(d2)));
        } else {
            c2 = this.dap2.getTextField2();
            if (c2 instanceof JTextField) {
                s2 = ((JTextField)c2).getText();
            }
            System.out.println(String.valueOf("Final activity : ").concat(String.valueOf(s2)));
            try {
                activitynew = Double.parseDouble(s2);
            }
            catch (Exception en2) {
                System.out.println("invalid value for activitynew");
                ErrorPane ep = new ErrorPane("No valid activity");
                return;
            }
        }
        if (activitycalculation) {
            if (activityold <= 0.0) {
                ErrorPane pane = new ErrorPane("No valid activity");
                return;
            }
            long difference = d2.getTime() - d1.getTime();
            System.out.println(String.valueOf(String.valueOf("Date difference : ").concat(String.valueOf(difference))).concat(String.valueOf(" milliseconds")));
            double daydiff = difference / (long)86400000;
            System.out.println(String.valueOf(String.valueOf("Date difference : ").concat(String.valueOf(daydiff))).concat(String.valueOf(" days")));
            activitynew = activityold * Math.exp(-1.0 * alpha * daydiff);
            System.out.println(String.valueOf("new activity = ").concat(String.valueOf(activitynew)));
            JResultsFrame jResultsFrame = new JResultsFrame(this.nuclidename, thalf, alpha, s1, activityold, s2, activitynew, daydiff, activitycalculation);
        } else {
            if (activityold <= 0.0 || activitynew <= 0.0) {
                ErrorPane ep = new ErrorPane("No valid activity");
                return;
            }
            double timediff = (Math.log(activityold) - Math.log(activitynew)) / alpha;
            System.out.println(String.valueOf("Time difference = ").concat(String.valueOf(timediff)));
            long timediffms = (long)(timediff * (double)86400000);
            System.out.println(String.valueOf("starting date = ").concat(String.valueOf(d1)));
            System.out.println(d1.getTime());
            System.out.println(String.valueOf(String.valueOf("adding ").concat(String.valueOf(timediffms))).concat(String.valueOf(" ms")));
            long newtime = d1.getTime() + timediffms;
            System.out.println(String.valueOf("new time = ").concat(String.valueOf(newtime)));
            d2 = d1;
            d2.setTime(newtime);
            System.out.println(String.valueOf("activity reached at date : ").concat(String.valueOf(d2)));
            int day = d2.getDate();
            int month = d2.getMonth() + 1;
            int year = d2.getYear() + 1900;
            String dateString = String.valueOf(String.valueOf(String.valueOf(String.valueOf(day).concat(String.valueOf("-"))).concat(String.valueOf(month))).concat(String.valueOf("-"))).concat(String.valueOf(year));
            JResultsFrame jResultsFrame = new JResultsFrame(this.nuclidename, thalf, alpha, s1, activityold, dateString, activitynew, timediff, activitycalculation);
        }
    }

    Date getDateFromString(String s) {
        Date date = new Date();
        String[] dateString = new String[3];
        SplitString ss = new SplitString();
        ss.setDelimiter('-');
        ss.setString(s.trim());
        try {
            dateString = ss.getStringArray();
            int day = Integer.parseInt(dateString[0]);
            date.setDate(day);
            int month = Integer.parseInt(dateString[1]) - 1;
            date.setMonth(month);
            int year = Integer.parseInt(dateString[2]) - 1900;
            date.setYear(year);
            int newday = date.getDate();
            int newmonth = date.getMonth() + 1;
            int newyear = date.getYear() + 1900;
            if (day != newday || month + 1 != newmonth || year + 1900 != newyear) {
                System.out.println("***** ERROR Invalid date *****");
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("day = ").concat(String.valueOf(day))).concat(String.valueOf(" month = "))).concat(String.valueOf(month + 1))).concat(String.valueOf(" year = "))).concat(String.valueOf(year + 1900)));
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("newday = ").concat(String.valueOf(newday))).concat(String.valueOf(" newmonth = "))).concat(String.valueOf(newmonth))).concat(String.valueOf(" newyear = "))).concat(String.valueOf(newyear)));
                ErrorPane ep = new ErrorPane("Date does not exist !");
                Date date2 = null;
                return date2;
            }
        }
        catch (Exception e1) {
            System.out.println("***** ERROR : Invalid date format in textfield *****");
            ErrorPane ep = new ErrorPane("Invalid date format");
            Date date3 = null;
            return date3;
        }
        return date;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

